
<style>
.card {
  border-radius: 12px;
  transition: transform .2s ease, box-shadow .2s ease;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 30px rgba(0,0,0,.15);
}
.btn {
  transition: all .2s ease;
}
.btn:hover {
  transform: translateY(-1px);
}
.table-hover tbody tr {
  transition: background-color .15s ease;
}
.fade-in {
  animation: fadeIn .4s ease-in-out;
}
@keyframes fadeIn {
  from {opacity:0; transform: translateY(6px);}
  to {opacity:1; transform:none;}
}
</style>

<div class="container my-4">
<div class="card shadow-sm fade-in">
<div class="card-body">
<?php

/* @var $this yii\web\View */
/* @var $model app\models\User */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="site-register">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h2 class="mb-0 text-center"><?= Html::encode($this->title) ?></h2>
                    </div>

                    <div class="card-body">
                        <?php $form = ActiveForm::begin([
                            'id' => 'register-form',
                            'fieldConfig' => [
                                'template' => "{label}\n{input}\n{error}",
                                'labelOptions' => ['class' => 'form-label'],
                                'inputOptions' => ['class' => 'form-control'],
                                'errorOptions' => ['class' => 'invalid-feedback'],
                            ],
                        ]); ?>

                        <div class="row">
                            <div class="col-12">
                                <?= $form->field($model, 'full_name')
                                    ->textInput(['autofocus' => true, 'placeholder' => 'Иванов Иван Иванович'])
                                    ->label('ФИО')
                                    ->hint('Только кириллические символы и пробелы') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'phone')
                                    ->textInput(['placeholder' => '8(999)999-99-99'])
                                    ->label('Телефон')
                                    ->hint('Формат: 8(XXX)XXX-XX-XX') ?>
                            </div>

                            <div class="col-md-6">
                                <?= $form->field($model, 'email')
                                    ->textInput(['placeholder' => 'example@mail.ru'])
                                    ->label('E-mail') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'password')
                                    ->passwordInput(['placeholder' => 'Минимум 8 символов'])
                                    ->label('Пароль') ?>
                            </div>

                            <div class="col-md-6">
                                <?= $form->field($model, 'password_repeat')
                                    ->passwordInput(['placeholder' => 'Повторите пароль'])
                                    ->label('Повторите пароль') ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <?= $form->field($model, 'agree_terms')->checkbox([
                                    'template' => "<div class=\"form-check\">\n{input} {label}\n{error}\n</div>",
                                    'labelOptions' => ['class' => 'form-check-label'],
                                ])->label('Я согласен с правилами регистрации') ?>

                                <p class="small text-muted">
                                    Нажимая кнопку «Зарегистрироваться», вы принимаете
                                    <a href="#" class="text-primary">Пользовательское соглашение</a> и
                                    <a href="#" class="text-primary">Политику конфиденциальности</a>.
                                </p>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <?= Html::submitButton('Зарегистрироваться', [
                                'class' => 'btn btn-primary btn-lg btn-lg w-100',
                                'name' => 'register-button'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                        <hr class="my-4">

                        <div class="text-center">
                            <p class="mb-2">Уже зарегистрированы?</p>
                            <?= Html::a('Войти в систему', ['site/login'], ['class' => 'btn btn-outline-primary']) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
// JavaScript для форматирования телефона
$js = <<<JS
$(document).ready(function() {
    // Форматирование телефона
    $('#user-phone').on('input', function() {
        var phone = $(this).val().replace(/\D/g, '');
        
        if (phone.length === 11 && phone[0] === '8') {
            phone = phone.replace(/(\d{1})(\d{3})(\d{3})(\d{2})(\d{2})/, '$1($2)$3-$4-$5');
            $(this).val(phone);
        }
    });
    
    // Валидация формы
    $('#register-form').on('submit', function(e) {
        var isValid = true;
        var errors = [];
        
        // Проверка ФИО (только кириллица и пробелы)
        var fullName = $('#user-full_name').val();
        var cyrillicRegex = /^[а-яА-ЯёЁ\s]+$/;
        if (!cyrillicRegex.test(fullName)) {
            errors.push('ФИО должно содержать только кириллические символы и пробелы');
            isValid = false;
        }
        
        // Проверка телефона
        var phone = $('#user-phone').val();
        var phoneRegex = /^8\(\d{3}\)\d{3}-\d{2}-\d{2}$/;
        if (!phoneRegex.test(phone)) {
            errors.push('Телефон должен быть в формате 8(XXX)XXX-XX-XX');
            isValid = false;
        }
        
        // Проверка пароля
        var password = $('#user-password').val();
        var passwordRepeat = $('#user-password_repeat').val();
        
        if (password.length < 8) {
            errors.push('Пароль должен содержать минимум 8 символов');
            isValid = false;
        }
        
        if (password !== passwordRepeat) {
            errors.push('Пароли не совпадают');
            isValid = false;
        }
        
        // Проверка согласия с правилами
        if (!$('#user-agree_terms').is(':checked')) {
            errors.push('Вы должны согласиться с правилами регистрации');
            isValid = false;
        }
        
        if (!isValid) {
            e.preventDefault();
            alert(errors.join('\\n'));
        }
    });
});
JS;
$this->registerJs($js);
?>
</div>
</div>
</div>