<style>
.profile-card {
  border-radius: 14px;
  transition: transform 0.25s ease, box-shadow 0.25s ease;
  border: 1px solid rgba(0,0,0,0.05);
}
.profile-card:hover {
  transform: translateY(-4px);
  box-shadow: 0 8px 24px rgba(0,0,0,0.08);
}

.status-badge {
  font-weight: 600;
  padding: 0.35em 0.8em;
  border-radius: 50px;
  font-size: 0.85rem;
}
.status-new { background: #fff8e1; color: #ff8f00; }
.status-approved { background: #e8f5e9; color: #2e7d32; }
.status-completed { background: #e3f2fd; color: #1565c0; }
.status-cancelled { background: #ffebee; color: #c62828; }

.card-header {
  border-bottom: none;
  padding: 1rem 1.25rem;
}
.card-header h3 {
  font-weight: 600;
  font-size: 1.25rem;
  display: flex;
  align-items: center;
  gap: 0.6rem;
}
</style>

<div class="container my-5">
  <div class="card shadow-sm fade-in">
    <div class="card-body p-0">
      <?php
      /* @var $this yii\web\View */
      /* @var $user app\models\User */
      /* @var $applications app\models\Application[] */

      use yii\helpers\Html;
      use yii\helpers\Url;
      use yii\widgets\DetailView;

      $this->title = 'Профиль пользователя';
      $this->params['breadcrumbs'][] = $this->title;
      ?>

      <div class="site-profile p-3 p-md-4">
        <div class="row g-4">
          <!-- Основной контент -->
          <div class="col-lg-8">
            <!-- Личные данные -->
            <div class="profile-card h-100">
              <div class="card-header bg-gradient-primary text-white">
                <h3><i class="fas fa-user-circle"></i> Личные данные</h3>
              </div>
              <div class="card-body">
                <?= DetailView::widget([
                  'model' => $user,
                  'template' => '<div class="row mb-3"><div class="col-sm-4 fw-medium text-muted">{label}</div><div class="col-sm-8">{value}</div></div>',
                  'attributes' => [
                    ['attribute' => 'full_name', 'label' => 'ФИО'],
                    ['attribute' => 'phone', 'label' => 'Телефон'],
                    ['attribute' => 'email', 'label' => 'E-mail'],
                    [
                      'attribute' => 'created_at',
                      'label' => 'Дата регистрации',
                      'format' => ['date', 'php:d.m.Y H:i'],
                    ],
                  ],
                ]) ?>

                <div class="text-center mt-4">
                  <a href="<?= Url::to(['site/update-profile']) ?>" class="btn btn-outline-primary px-4">
                    <i class="fas fa-edit me-1"></i> Редактировать профиль
                  </a>
                </div>
              </div>
            </div>

            <!-- Мои заявки -->
            <div class="profile-card mt-4">
              <div class="card-header bg-gradient-primary text-white">
                <h3><i class="fas fa-list-check"></i> Мои заявки</h3>
              </div>
              <div class="card-body">
                <?php if ($applications): ?>
                  <div class="table-responsive">
                    <table class="table table-hover mb-0">
                      <thead>
                        <tr class="text-muted small">
                          <th>Игра</th>
                          <th>Дата и время</th>
                          <th>Статус</th>
                          <th class="text-end">Действия</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($applications as $application): ?>
                          <tr>
                            <td class="fw-medium"><?= Html::encode($application->game_name) ?></td>
                            <td><?= Yii::$app->formatter->asDate($application->date) ?>, <?= $application->start_time ?></td>
                            <td>
                              <span class="status-badge status-<?= $application->status ?>">
                                <?= $application->getStatusLabel() ?>
                              </span>
                            </td>
                            <td class="text-end">
                              <a href="<?= Url::to(['site/view-application', 'id' => $application->id]) ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i>
                              </a>
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>
                <?php else: ?>
                  <div class="text-center py-5">
                    <div class="bg-light d-inline-flex align-items-center justify-content-center rounded-circle mb-3" style="width:72px; height:72px;">
                      <i class="fas fa-clipboard-list fa-2x text-muted"></i>
                    </div>
                    <p class="text-muted mb-3">У вас пока нет заявок</p>
                    <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-primary">
                      <i class="fas fa-calendar-plus me-1"></i> Записаться на игру
                    </a>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <!-- Боковая панель -->
          <div class="col-lg-4">
            <!-- Быстрые действия -->
            <div class="profile-card mb-4">
              <div class="card-header bg-gradient-success text-white">
                <h3><i class="fas fa-bolt"></i> Быстрые действия</h3>
              </div>
              <div class="card-body">
                <div class="d-grid gap-2">
                  <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-success btn-lg">
                    <i class="fas fa-calendar-plus me-2"></i> Записаться на игру
                  </a>
                  <a href="<?= Url::to(['site/applications']) ?>" class="btn btn-outline-primary">
                    <i class="fas fa-list-alt me-2"></i> Все мои заявки
                  </a>
                  <a href="<?= Url::to(['site/catalog']) ?>" class="btn btn-outline-primary">
                    <i class="fas fa-th-list me-2"></i> Каталог игр
                  </a>
                </div>
              </div>
            </div>

            <!-- Статистика -->
            <div class="profile-card">
              <div class="card-header bg-gradient-info text-white">
                <h3><i class="fas fa-chart-simple"></i> Статистика</h3>
              </div>
              <div class="card-body">
                <div class="d-flex justify-content-around text-center flex-wrap gap-3">
                  <div>
                    <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-2" style="width:56px; height:56px;">
                      <i class="fas fa-file-signature text-primary fa-lg"></i>
                    </div>
                    <h4 class="mb-1"><?= count($applications) ?></h4>
                    <small class="text-muted">Всего заявок</small>
                  </div>

                  <div>
                    <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-2" style="width:56px; height:56px;">
                      <i class="fas fa-check-circle text-success fa-lg"></i>
                    </div>
                    <h4 class="mb-1">
                      <?= count(array_filter($applications, fn($app) => $app->status === 'approved')) ?>
                    </h4>
                    <small class="text-muted">Подтверждено</small>
                  </div>

                  <div>
                    <div class="bg-info bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-2" style="width:56px; height:56px;">
                      <i class="fas fa-trophy text-info fa-lg"></i>
                    </div>
                    <h4 class="mb-1">
                      <?= count(array_filter($applications, fn($app) => $app->status === 'completed')) ?>
                    </h4>
                    <small class="text-muted">Завершено</small>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.bg-gradient-primary { background: linear-gradient(135deg, #0d6efd, #0b5ed7); }
.bg-gradient-success { background: linear-gradient(135deg, #198754, #157347); }
.bg-gradient-info    { background: linear-gradient(135deg, #0dcaf0, #0baccc); }
</style>