<style>
.card {
  border-radius: 16px;
  transition: transform 0.25s ease, box-shadow 0.25s ease;
}
.card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}

.btn {
  transition: all 0.2s ease;
}
.btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.fade-in {
  animation: fadeIn 0.5s ease-out forwards;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: none; }
}

.contact-icon {
  width: 80px;
  height: 80px;
  display: flex;
  align-items: center;
  justify-content: center;
  background: linear-gradient(135deg, #e7f1ff, #d0e4ff);
  border-radius: 50%;
  margin: 0 auto 16px;
  color: #0d6efd;
  font-size: 28px;
  box-shadow: 0 4px 10px rgba(13, 110, 253, 0.15);
}
</style>

<div class="container my-5">
  <div class="card shadow-sm fade-in">
    <div class="card-body p-0">
      <?php
      /* @var $this yii\web\View */
      use yii\helpers\Html;

      $this->title = 'Контакты';
      $this->params['breadcrumbs'][] = $this->title;
      ?>

      <div class="site-contact">
        <div class="row g-0">
          <!-- Левая колонка: заголовок + карта (на больших экранах) -->
          <div class="col-lg-6 d-flex align-items-center justify-content-center p-5 bg-light bg-opacity-25">
            <div class="text-center w-100">
              <h1 class="display-5 fw-bold text-primary mb-4"><?= Html::encode($this->title) ?></h1>
              <p class="text-muted lead">Свяжитесь с нами — мы всегда рады помочь!</p>
            </div>
          </div>

          <!-- Правая колонка: карточки контактов -->
          <div class="col-lg-6">
            <div class="p-4 p-md-5">
              <div class="row g-4">
                <!-- Адрес -->
                <div class="col-12 col-md-6">
                  <div class="contact-item text-center p-4 h-100">
                    <div class="contact-icon">
                      <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Адрес</h5>
                    <p class="mb-1">г. Москва, ул. Примерная, д. 10</p>
                    <small class="text-muted">Ближайшее метро: «Примерная»</small>
                  </div>
                </div>

                <!-- Телефон -->
                <div class="col-12 col-md-6">
                  <div class="contact-item text-center p-4 h-100">
                    <div class="contact-icon">
                      <i class="fas fa-phone-alt"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Телефон</h5>
                    <p class="mb-1"><a href="tel:+74951234567" class="text-decoration-none text-dark">+7 (495) 123-45-67</a></p>
                    <small class="text-muted">Ежедневно с 10:00 до 22:00</small>
                  </div>
                </div>

                <!-- Email -->
                <div class="col-12 col-md-6">
                  <div class="contact-item text-center p-4 h-100">
                    <div class="contact-icon">
                      <i class="fas fa-envelope"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Email</h5>
                    <p class="mb-1"><a href="mailto:info@nastolka.ru" class="text-decoration-none text-dark">info@nastolka.ru</a></p>
                    <small class="text-muted">Для общих вопросов</small>
                  </div>
                </div>

                <!-- Режим работы -->
                <div class="col-12 col-md-6">
                  <div class="contact-item text-center p-4 h-100">
                    <div class="contact-icon">
                      <i class="fas fa-clock"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Режим работы</h5>
                    <p class="mb-1">Пн–Вс: 10:00 – 22:00</p>
                    <small class="text-muted">Предварительная запись обязательна</small>
                  </div>
                </div>
              </div>

              <!-- Карта -->
              <div class="mt-5">
                <h4 class="text-center mb-4 fw-bold">Мы на карте</h4>
                <div class="ratio ratio-16x9 rounded-3 overflow-hidden shadow-sm border">
                  <!-- Заглушка карты -->
                  <div class="bg-light d-flex align-items-center justify-content-center">
                    <div class="text-center p-3">
                      <i class="fas fa-map-marked-alt fa-4x text-muted mb-3"></i>
                      <p class="text-muted mb-0">Интерактивная карта<br><small class="text-secondary">в разработке</small></p>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Соцсети -->
              <div class="text-center mt-5">
                <h4 class="mb-4 fw-bold">Мы в соцсетях</h4>
                <div class="d-flex justify-content-center gap-3 flex-wrap">
                  <a href="https://vk.com/nastolka" target="_blank" class="btn btn-lg btn-outline-primary px-4">
                    <i class="fab fa-vk me-2"></i> VK
                  </a>
                  <a href="https://t.me/nastolkanow" target="_blank" class="btn btn-lg btn-outline-primary px-4">
                    <i class="fab fa-telegram-plane me-2"></i> Telegram
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <?php
      $css = <<<CSS
.contact-item {
  background: #ffffff;
  border-radius: 14px;
  transition: all 0.3s ease;
  border: 1px solid #e9ecef;
  box-shadow: 0 2px 8px rgba(0,0,0,0.04);
}

.contact-item:hover {
  transform: translateY(-4px);
  box-shadow: 0 6px 16px rgba(0,0,0,0.1);
  border-color: #dde7ff;
}

.contact-item a {
  color: inherit;
}
.contact-item a:hover {
  color: #0d6efd;
}

@media (max-width: 992px) {
  .site-contact .row.g-0 > div {
    padding: 20px !important;
  }
}
CSS;
      $this->registerCss($css);
      ?>
    </div>
  </div>
</div>