<style>
.card {
  border-radius: 14px;
  transition: transform 0.25s ease, box-shadow 0.25s ease;
  border: 1px solid #eaeaea;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 8px 24px rgba(0,0,0,0.12);
}

.fade-in {
  animation: fadeIn 0.4s ease-out;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(8px); }
  to { opacity: 1; transform: none; }
}

.status-badge {
  font-weight: 600;
  padding: 0.4em 0.8em;
  border-radius: 50px;
  font-size: 0.9em;
}
.status-draft { background: #f0f8ff; color: #4682b4; }
.status-pending { background: #fff8e1; color: #ff8f00; }
.status-confirmed { background: #e8f5e9; color: #2e7d32; }
.status-cancelled { background: #ffebee; color: #c62828; }

.application-icon {
  font-size: 1.4rem;
  opacity: 0.8;
}
</style>

<div class="container my-5">
  <div class="card shadow-sm fade-in">
    <div class="card-body p-4 p-md-5">
      <?php
      /* @var $this yii\web\View */
      /* @var $dataProvider yii\data\ActiveDataProvider */

      use yii\helpers\Html;
      use yii\helpers\Url;
      use yii\widgets\ListView;

      $this->title = 'Мои заявки';
      $this->params['breadcrumbs'][] = $this->title;
      ?>

      <div class="site-applications">
        <!-- Заголовок и кнопка -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-5 gap-3">
          <div>
            <h1 class="h2 fw-bold text-dark mb-1"><?= Html::encode($this->title) ?></h1>
            <p class="text-muted mb-0">Все ваши записи на настольные игры</p>
          </div>
          <a href="<?= Url::to(['site/create-application']) ?>" class="btn btn-primary btn-lg px-4">
            <i class="fas fa-plus me-2"></i>Новая заявка
          </a>
        </div>

        <!-- Flash-сообщение -->
        <?php if (Yii::$app->session->hasFlash('success')): ?>
          <div class="alert alert-success alert-dismissible fade show rounded-3 mb-5" role="alert">
            <?= Yii::$app->session->getFlash('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>

        <!-- Список заявок -->
        <?= ListView::widget([
            'dataProvider' => $dataProvider,
            'itemView' => '_application_card',
            'layout' => "{items}\n{pager}",
            'emptyText' => '
                <div class="col-12">
                    <div class="text-center py-5">
                        <div class="bg-light d-inline-flex align-items-center justify-content-center rounded-circle mb-4" style="width:96px; height:96px;">
                            <i class="fas fa-clipboard-list fa-3x text-muted"></i>
                        </div>
                        <h3 class="mb-3">Нет активных заявок</h3>
                        <p class="text-muted mb-4">Вы ещё не записывались на игры.<br>Создайте первую заявку — это займёт всего пару минут!</p>
                        <a href="' . Url::to(['site/create-application']) . '" class="btn btn-primary btn-lg px-5 py-2">
                            <i class="fas fa-calendar-plus me-2"></i>Записаться на игру
                        </a>
                    </div>
                </div>',
            'options' => ['class' => 'row g-4'],
            'itemOptions' => ['class' => 'col-md-6 col-xl-4'],
        ]); ?>

      </div>
    </div>
  </div>
</div>

<!-- Пример улучшенной структуры для _application_card.php (для справки) -->
<?php
/*
В файле `views/site/_application_card.php` убедитесь, что карточка выглядит так:

<div class="card h-100 shadow-sm">
    <div class="card-body d-flex flex-column">
        <div class="d-flex justify-content-between align-items-start mb-3">
            <h5 class="card-title mb-1"><?= Html::encode($model->game_name) ?></h5>
            <span class="status-badge status-<?= $model->status ?>"><?= $model->getStatusLabel() ?></span>
        </div>
        <p class="text-muted small mb-2">
            <i class="fas fa-calendar-day application-icon me-2"></i>
            <?= Yii::$app->formatter->asDate($model->date) ?>
        </p>
        <p class="text-muted small mb-2">
            <i class="fas fa-clock application-icon me-2"></i>
            <?= $model->start_time ?>
        </p>
        <p class="text-muted small mb-3">
            <i class="fas fa-map-marker-alt application-icon me-2"></i>
            <?= Html::encode($model->address) ?>
        </p>

        <div class="mt-auto pt-2">
            <div class="d-flex justify-content-between align-items-center">
                <span class="fw-bold text-primary"><?= $model->price ?> ₽</span>
                <a href="<?= Url::to(['site/view-application', 'id' => $model->id]) ?>" class="btn btn-outline-primary btn-sm">Подробнее</a>
            </div>
        </div>
    </div>
</div>
*/
?>