<?php
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ListView;

$this->title = 'Управление пользователями';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-users">
    <!-- Хедер страницы -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Управление пользователями системы</p>
                </div>
                <div class="text-end">
                    <span class="badge bg-primary-light text-primary">
                        <i class="fas fa-users me-1"></i>
                        Всего: <?= $dataProvider->getTotalCount() ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Карточки статистики -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-primary-light text-primary me-3">
                            <i class="fas fa-user-plus"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Новых за месяц</div>
                            <div class="h4 mb-0"><?= \app\models\User::find()
                                ->where(['>=', 'created_at', date('Y-m-01')])
                                ->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-success-light text-success me-3">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Активных пользователей</div>
                            <div class="h4 mb-0"><?= \app\models\User::find()
                                ->joinWith('applications')
                                ->where(['>=', 'application.created_at', date('Y-m-01')])
                                ->distinct()
                                ->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-info-light text-info me-3">
                            <i class="fas fa-star"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Оставили отзывы</div>
                            <div class="h4 mb-0"><?= \app\models\Review::find()
                                ->select('user_id')
                                ->distinct()
                                ->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-warning-light text-warning me-3">
                            <i class="fas fa-crown"></i>
                        </div>
                        <div>
                            <div class="text-muted small mb-1">Администраторов</div>
                            <div class="h4 mb-0"><?= \app\models\User::find()
                                ->where(['phone' => '89999999999'])
                                ->count() ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Таблица пользователей -->
    <div class="card border-0 shadow-sm">
        <div class="card-header border-0 bg-transparent d-flex justify-content-between align-items-center py-4">
            <h5 class="mb-0 fw-medium">Список пользователей</h5>
            <div class="d-flex gap-2">
                <div class="input-group input-group-sm" style="width: 300px;">
                    <span class="input-group-text bg-light border-end-0">
                        <i class="fas fa-search text-muted"></i>
                    </span>
                    <input type="text" class="form-control border-start-0 ps-0" 
                           placeholder="Поиск пользователей..." id="user-search">
                </div>
                <button class="btn btn-sm btn-outline-primary rounded-pill" id="export-users">
                    <i class="fas fa-download me-1"></i> Экспорт
                </button>
            </div>
        </div>
        <div class="card-body pt-0">
            <div class="table-responsive">
                <table class="table table-hover table-borderless align-middle">
                    <thead class="table-light">
                    <tr>
                        <th class="small text-uppercase text-muted" width="80">ID</th>
                        <th class="small text-uppercase text-muted">ФИО</th>
                        <th class="small text-uppercase text-muted">Телефон</th>
                        <th class="small text-uppercase text-muted">Email</th>
                        <th class="small text-uppercase text-muted" width="140">Дата регистрации</th>
                        <th class="small text-uppercase text-muted" width="120">Заявок</th>
                        <th class="small text-uppercase text-muted text-end" width="100">Действия</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?= ListView::widget([
                        'dataProvider' => $dataProvider,
                        'itemView' => '_user_item',
                        'layout' => "{items}",
                        'emptyText' => '<tr>
                            <td colspan="7" class="text-center py-5">
                                <div class="empty-state">
                                    <i class="fas fa-users fa-3x text-light mb-3"></i>
                                    <p class="text-muted mb-0">Пользователи не найдены</p>
                                    <small class="text-muted">Попробуйте изменить параметры поиска</small>
                                </div>
                            </td>
                        </tr>',
                    ]); ?>
                    </tbody>
                </table>
            </div>

            <!-- Пагинация -->
            <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-4 pt-3 border-top">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Показано <?= $dataProvider->getCount() ?> из <?= $dataProvider->getTotalCount() ?> пользователей
                    </div>
                    <nav aria-label="Пагинация">
                        <?= \yii\widgets\LinkPager::widget([
                            'pagination' => $dataProvider->pagination,
                            'options' => [
                                'class' => 'pagination justify-content-center mb-0',
                            ],
                            'linkContainerOptions' => ['class' => 'page-item'],
                            'linkOptions' => ['class' => 'page-link rounded'],
                            'disabledListItemSubTagOptions' => ['class' => 'page-link rounded'],
                        ]) ?>
                    </nav>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
// JS для поиска пользователей
$js = <<<JS
$(document).ready(function() {
    // Поиск пользователей
    $('#user-search').on('keyup', function() {
        var search = $(this).val().toLowerCase();
        $('.user-item').each(function() {
            var text = $(this).text().toLowerCase();
            $(this).toggle(text.indexOf(search) > -1);
        });
    });
    
    // Экспорт пользователей
    $('#export-users').on('click', function() {
        window.location.href = '/admin/export-users';
    });
});
JS;
$this->registerJs($js);
?>