<?php
/* @var $this yii\web\View */
/* @var $model app\models\Schedule */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Редактирование расписания #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Управление расписанием', 'url' => ['schedule']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-update-schedule">
    <!-- Хедер страницы -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Редактирование информации о расписании</p>
                </div>
                <a href="<?= Url::to(['admin/schedule']) ?>" class="btn btn-outline-secondary rounded-pill">
                    <i class="fas fa-arrow-left me-2"></i> Назад к списку
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Основная форма -->
        <div class="col-lg-8">
            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'needs-validation', 'novalidate' => true]
            ]); ?>
            
            <div class="card border-0 shadow-sm">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-primary">
                        <i class="fas fa-calendar-edit me-2"></i>Редактирование расписания
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Игра -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-gamepad me-1 text-primary"></i>Игра
                                </label>
                                <?= $form->field($model, 'game_id', [
                                    'options' => ['class' => 'mb-0']
                                ])->dropDownList(
                                    \yii\helpers\ArrayHelper::map(
                                        \app\models\Game::find()->all(),
                                        'id',
                                        function($game) {
                                            return $game->name . ' (' . $game->getCategoryLabel() . ')';
                                        }
                                    ),
                                    [
                                        'prompt' => 'Выберите игру',
                                        'class' => 'form-select rounded-pill'
                                    ]
                                )->label(false) ?>
                            </div>
                        </div>

                        <!-- Дата -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-calendar me-1 text-primary"></i>Дата проведения
                                </label>
                                <?= $form->field($model, 'date', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'type' => 'date',
                                    'class' => 'form-control rounded-pill'
                                ])->label(false) ?>
                            </div>
                        </div>

                        <!-- Время начала -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="far fa-clock me-1 text-primary"></i>Время начала
                                </label>
                                <?= $form->field($model, 'start_time', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'type' => 'time',
                                    'class' => 'form-control rounded-pill'
                                ])->label(false) ?>
                            </div>
                        </div>

                        <!-- Стоимость -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-money-bill-wave me-1 text-primary"></i>Стоимость (₽)
                                </label>
                                <?= $form->field($model, 'price', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'type' => 'number',
                                    'step' => '0.01',
                                    'class' => 'form-control rounded-pill'
                                ])->label(false) ?>
                            </div>
                        </div>

                        <!-- Максимум игроков -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-users me-1 text-primary"></i>Максимум игроков
                                </label>
                                <?= $form->field($model, 'max_players', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'type' => 'number',
                                    'min' => 1,
                                    'class' => 'form-control rounded-pill'
                                ])->label(false) ?>
                            </div>
                        </div>

                        <!-- Текущее количество игроков -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-user-check me-1 text-primary"></i>Текущее количество
                                </label>
                                <?= $form->field($model, 'current_players', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'type' => 'number',
                                    'min' => 0,
                                    'class' => 'form-control rounded-pill'
                                ])->label(false) ?>
                            </div>
                        </div>

                        <!-- Адрес -->
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label fw-medium mb-2">
                                    <i class="fas fa-map-marker-alt me-1 text-primary"></i>Адрес проведения
                                </label>
                                <?= $form->field($model, 'address', [
                                    'options' => ['class' => 'mb-0']
                                ])->textInput([
                                    'class' => 'form-control rounded-pill',
                                    'placeholder' => 'Например: г. Москва, ул. Примерная, д. 10'
                                ])->label(false) ?>
                            </div>
                        </div>
                    </div>

                    <!-- Кнопки формы -->
                    <div class="d-flex gap-3 mt-5">
                        <?= Html::submitButton('<i class="fas fa-save me-2"></i>Сохранить изменения', [
                            'class' => 'btn btn-success btn-lg rounded-pill px-4'
                        ]) ?>
                        <?= Html::a('<i class="fas fa-times me-2"></i>Отмена', 
                            ['schedule'], 
                            ['class' => 'btn btn-outline-secondary btn-lg rounded-pill px-4']
                        ) ?>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>

        <!-- Боковая панель -->
        <div class="col-lg-4">
            <!-- Информация -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-info">
                        <i class="fas fa-info-circle me-2"></i>Информация
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-3 d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-calendar-plus"></i>
                            </div>
                            <div>
                                <div class="small text-muted">Создано</div>
                                <div class="fw-medium"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></div>
                            </div>
                        </li>
                        <li class="mb-3 d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-users"></i>
                            </div>
                            <div>
                                <div class="small text-muted">Заявок на игру</div>
                                <div class="fw-medium">
                                    <span class="badge bg-primary-light text-primary rounded-pill px-3">
                                        <?= count($model->applications) ?>
                                    </span>
                                </div>
                            </div>
                        </li>
                        <li class="d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                            <div>
                                <div class="small text-muted">Следующая игра</div>
                                <div class="fw-medium">
                                    <?php if (strtotime($model->date) >= strtotime(date('Y-m-d'))): ?>
                                        <span class="badge bg-success-light text-success rounded-pill">
                                            <?= Yii::$app->formatter->asRelativeTime($model->date . ' ' . $model->start_time) ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary-light text-secondary rounded-pill">
                                            Прошло
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Быстрые действия -->
            <div class="card border-0 shadow-sm">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-warning">
                        <i class="fas fa-bolt me-2"></i>Быстрые действия
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-3">
                        <button type="button" class="btn btn-outline-success rounded-pill" id="duplicate-btn">
                            <i class="fas fa-copy me-2"></i>Дублировать запись
                        </button>
                        <button type="button" class="btn btn-outline-danger rounded-pill" 
                                data-bs-toggle="modal" data-bs-target="#deleteModal">
                            <i class="fas fa-trash me-2"></i>Удалить расписание
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Модальное окно удаления -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0 pb-0 pt-4 px-4">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Подтверждение удаления
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body px-4">
                <div class="text-center mb-4">
                    <div class="icon-circle bg-danger-light text-danger mx-auto mb-3" style="width: 64px; height: 64px;">
                        <i class="fas fa-trash fa-2x"></i>
                    </div>
                    <h5>Вы уверены, что хотите удалить это расписание?</h5>
                    <p class="text-danger mb-0">
                        <i class="fas fa-exclamation-circle me-1"></i>
                        Все заявки на эту игру будут удалены.
                    </p>
                </div>
            </div>
            <div class="modal-footer border-0 pt-3 pb-4 px-4">
                <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">Отмена</button>
                <?= Html::a('Удалить', ['delete-schedule', 'id' => $model->id], [
                    'class' => 'btn btn-danger rounded-pill px-4',
                    'data-method' => 'post',
                ]) ?>
            </div>
        </div>
    </div>
</div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Дублирование записи
    $('#duplicate-btn').on('click', function() {
        if (confirm('Создать копию этой записи расписания?')) {
            $.ajax({
                url: '/admin/duplicate-schedule?id=' + $model->id,
                type: 'POST',
                data: {
                    _csrf: yii.getCsrfToken()
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = '/admin/update-schedule?id=' + response.id;
                    } else {
                        alert('Ошибка при дублировании: ' + response.message);
                    }
                }
            });
        }
    });
});
JS;
$this->registerJs($js);
?>