<?php
/* @var $this yii\web\View */
/* @var $model app\models\Application */

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Редактирование заявки #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Управление заявками', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-update-application">
    <!-- Хедер страницы -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div>
                    <h1 class="h2 mb-2"><?= Html::encode($this->title) ?></h1>
                    <p class="text-muted">Редактирование информации о заявке</p>
                </div>
                <a href="<?= Url::to(['admin/applications']) ?>" class="btn btn-outline-secondary rounded-pill">
                    <i class="fas fa-arrow-left me-2"></i> Назад к списку
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Основная форма -->
        <div class="col-lg-8">
            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'needs-validation', 'novalidate' => true]
            ]); ?>
            
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-primary">
                        <i class="fas fa-edit me-2"></i>Редактирование заявки
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Статус и оплата -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <?= $form->field($model, 'status', [
                                'options' => ['class' => 'mb-0']
                            ])->dropDownList(
                                \app\models\Application::getStatuses(),
                                ['class' => 'form-select form-select-lg rounded-pill']
                            )->label('Статус заявки', ['class' => 'form-label fw-medium']) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'payment_method', [
                                'options' => ['class' => 'mb-0']
                            ])->dropDownList(
                                \app\models\Application::getPaymentMethods(),
                                ['class' => 'form-select form-select-lg rounded-pill']
                            )->label('Способ оплаты', ['class' => 'form-label fw-medium']) ?>
                        </div>
                    </div>

                    <!-- Предупреждение -->
                    <div class="alert alert-info border-0 bg-info-light rounded-3 mb-4">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="fas fa-info"></i>
                            </div>
                            <div>
                                <p class="mb-0 small">
                                    <strong>Внимание:</strong> При изменении статуса пользователь получит уведомление на email.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Согласие -->
                    <div class="form-check form-switch mb-4">
                        <?= $form->field($model, 'personal_data_agreement')
                            ->checkbox([
                                'class' => 'form-check-input',
                                'disabled' => 'disabled',
                                'style' => 'transform: scale(1.5);'
                            ])
                            ->label('Согласие на обработку персональных данных', [
                                'class' => 'form-check-label fw-medium'
                            ]) ?>
                    </div>

                    <!-- Кнопки формы -->
                    <div class="d-flex gap-3">
                        <?= Html::submitButton('<i class="fas fa-save me-2"></i>Сохранить изменения', [
                            'class' => 'btn btn-success btn-lg rounded-pill px-4'
                        ]) ?>
                        <?= Html::a('<i class="fas fa-times me-2"></i>Отмена', 
                            ['applications'], 
                            ['class' => 'btn btn-outline-secondary btn-lg rounded-pill px-4']
                        ) ?>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>

        <!-- Боковая панель -->
        <div class="col-lg-4">
            <!-- Информация о заявке -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-info">
                        <i class="fas fa-info-circle me-2"></i>Информация
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-3 d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-calendar-plus"></i>
                            </div>
                            <div>
                                <div class="small text-muted">Создана</div>
                                <div class="fw-medium"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></div>
                            </div>
                        </li>
                        <li class="mb-3 d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-sync-alt"></i>
                            </div>
                            <div>
                                <div class="small text-muted">Обновлена</div>
                                <div class="fw-medium"><?= Yii::$app->formatter->asDatetime($model->updated_at) ?></div>
                            </div>
                        </li>
                        <li class="d-flex align-items-center">
                            <div class="icon-circle-sm bg-light text-muted me-3">
                                <i class="fas fa-user"></i>
                            </div>
                            <div>
                                <div class="small text-muted">ID пользователя</div>
                                <div class="fw-medium"><?= $model->user_id ?></div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Быстрые действия -->
            <div class="card border-0 shadow-sm">
                <div class="card-header border-0 bg-transparent py-4">
                    <h5 class="mb-0 fw-medium text-warning">
                        <i class="fas fa-bolt me-2"></i>Быстрые действия
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-3">
                        <button type="button" class="btn btn-success rounded-pill" id="approve-btn">
                            <i class="fas fa-check-circle me-2"></i>Одобрить заявку
                        </button>
                        <button type="button" class="btn btn-info rounded-pill" id="complete-btn">
                            <i class="fas fa-flag-checkered me-2"></i>Завершить заявку
                        </button>
                        <button type="button" class="btn btn-outline-danger rounded-pill" data-bs-toggle="modal" data-bs-target="#deleteModal">
                            <i class="fas fa-trash me-2"></i>Удалить заявку
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Модальное окно удаления -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0 pb-0 pt-4 px-4">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>Подтверждение удаления
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body px-4">
                <div class="text-center mb-4">
                    <div class="icon-circle bg-danger-light text-danger mx-auto mb-3" style="width: 64px; height: 64px;">
                        <i class="fas fa-trash fa-2x"></i>
                    </div>
                    <h5>Вы уверены, что хотите удалить заявку #<?= $model->id ?>?</h5>
                    <p class="text-muted mb-0">Это действие нельзя отменить.</p>
                </div>
            </div>
            <div class="modal-footer border-0 pt-3 pb-4 px-4">
                <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">Отмена</button>
                <?= Html::a('Удалить', ['delete-application', 'id' => $model->id], [
                    'class' => 'btn btn-danger rounded-pill px-4',
                    'data-method' => 'post',
                ]) ?>
            </div>
        </div>
    </div>
</div>

<?php
$js = <<<JS
$(document).ready(function() {
    // Быстрое одобрение
    $('#approve-btn').on('click', function() {
        $('#application-status').val('approved').trigger('change');
        $('form').submit();
    });
    
    // Быстрое завершение
    $('#complete-btn').on('click', function() {
        $('#application-status').val('completed').trigger('change');
        $('form').submit();
    });
});
JS;
$this->registerJs($js);
?>