<?php
/* @var $model app\models\Review */
use yii\helpers\Html;
?>
<div class="modal fade" id="reviewModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0 pb-0 pt-4 px-4">
                <div>
                    <h5 class="modal-title mb-1">Отзыв #<?= $model->id ?></h5>
                    <p class="text-muted small mb-0">
                        <i class="fas fa-clock me-1"></i>
                        <?= Yii::$app->formatter->asRelativeTime($model->created_at) ?>
                    </p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body px-4">
                <!-- Рейтинг -->
                <div class="text-center mb-4">
                    <div class="display-4 text-warning mb-2">
                        <?= str_repeat('★', $model->rating) ?><?= str_repeat('☆', 5 - $model->rating) ?>
                    </div>
                    <span class="badge bg-warning-light text-warning rounded-pill px-3 py-1">
                        Рейтинг: <?= $model->rating ?>/5
                    </span>
                </div>

                <!-- Текст отзыва -->
                <div class="card border-light shadow-sm mb-4">
                    <div class="card-body">
                        <h6 class="card-title text-muted small text-uppercase mb-3">Текст отзыва:</h6>
                        <p class="card-text lead">
                            <?= nl2br(Html::encode($model->comment)) ?>
                        </p>
                    </div>
                </div>

                <!-- Информация об авторе -->
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="card border-light shadow-sm h-100">
                            <div class="card-body">
                                <h6 class="card-title text-muted small text-uppercase mb-3">Автор:</h6>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-circle bg-light text-muted me-3">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <div>
                                        <?php if ($model->user): ?>
                                            <div class="fw-medium"><?= Html::encode($model->user->full_name) ?></div>
                                            <small class="text-muted"><?= Html::encode($model->user->email) ?></small>
                                        <?php else: ?>
                                            <div class="text-muted">Пользователь удален</div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card border-light shadow-sm h-100">
                            <div class="card-body">
                                <h6 class="card-title text-muted small text-uppercase mb-3">Дата создания:</h6>
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-info-light text-info me-3">
                                        <i class="fas fa-calendar"></i>
                                    </div>
                                    <div>
                                        <div class="fw-medium"><?= Yii::$app->formatter->asDate($model->created_at) ?></div>
                                        <small class="text-muted"><?= Yii::$app->formatter->asTime($model->created_at) ?></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($model->application): ?>
                <div class="card border-light shadow-sm mt-4">
                    <div class="card-body">
                        <h6 class="card-title text-muted small text-uppercase mb-3">Связанная заявка:</h6>
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary-light text-primary me-3">
                                <i class="fas fa-gamepad"></i>
                            </div>
                            <div>
                                <div class="fw-medium"><?= Html::encode($model->application->game_name) ?></div>
                                <div class="text-muted small">
                                    <i class="far fa-calendar me-1"></i>
                                    <?= Yii::$app->formatter->asDate($model->application->date) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer border-0 pt-3 pb-4 px-4">
                <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">Закрыть</button>
                <?= Html::a('Удалить', ['delete-review', 'id' => $model->id], [
                    'class' => 'btn btn-danger rounded-pill px-4',
                    'data-method' => 'post',
                    'data-confirm' => 'Вы уверены, что хотите удалить этот отзыв?'
                ]) ?>
            </div>
        </div>
    </div>
</div>