<?php
/* @var $model app\models\Application */
use yii\helpers\Html;
use yii\helpers\Url;
?>
<div class="modal fade" id="applicationModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0 pb-0 pt-4 px-4">
                <div>
                    <h5 class="modal-title mb-1">
                        <span class="badge bg-light text-dark me-2">#<?= $model->id ?></span>
                        Заявка
                    </h5>
                    <p class="text-muted small mb-0">
                        <i class="fas fa-clock me-1"></i>
                        Создана <?= Yii::$app->formatter->asRelativeTime($model->created_at) ?>
                    </p>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body px-4">
                <!-- Статус -->
                <div class="d-flex align-items-center justify-content-between mb-4">
                    <div>
                        <span class="badge rounded-pill bg-<?= $model->status === 'new' ? 'warning' :
                            ($model->status === 'approved' ? 'success' : 'info') ?>-light text-<?= $model->status === 'new' ? 'warning' :
                            ($model->status === 'approved' ? 'success' : 'info') ?> px-3 py-2">
                            <i class="fas <?= $model->status === 'new' ? 'fa-clock' : 
                                ($model->status === 'approved' ? 'fa-check-circle' : 'fa-flag-checkered') ?> me-2"></i>
                            <?= $model->getStatusLabel() ?>
                        </span>
                    </div>
                    <div class="text-end">
                        <div class="h4 mb-0"><?= $model->price ?> ₽</div>
                        <small class="text-muted">Стоимость</small>
                    </div>
                </div>

                <div class="row g-4">
                    <!-- Информация об игре -->
                    <div class="col-md-6">
                        <div class="card border-light shadow-sm h-100">
                            <div class="card-body">
                                <h6 class="card-title text-muted small text-uppercase mb-3">
                                    <i class="fas fa-gamepad me-2"></i>Информация об игре
                                </h6>
                                
                                <div class="mb-3">
                                    <label class="form-label small text-muted mb-1">Название игры:</label>
                                    <div class="fw-medium"><?= Html::encode($model->game_name) ?></div>
                                </div>
                                
                                <div class="row g-2 mb-3">
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Категория:</label>
                                        <div class="badge bg-secondary-light text-secondary rounded-pill">
                                            <?= $model->game_category ?>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Дата:</label>
                                        <div class="fw-medium">
                                            <?= Yii::$app->formatter->asDate($model->date) ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label small text-muted mb-1">Время начала:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="icon-circle-xs bg-light text-muted me-2">
                                            <i class="far fa-clock"></i>
                                        </div>
                                        <span class="fw-medium"><?= $model->start_time ?></span>
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="form-label small text-muted mb-1">Адрес:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="icon-circle-xs bg-light text-muted me-2">
                                            <i class="fas fa-map-marker-alt"></i>
                                        </div>
                                        <span class="fw-medium"><?= Html::encode($model->address) ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Информация о пользователе -->
                    <div class="col-md-6">
                        <div class="card border-light shadow-sm h-100">
                            <div class="card-body">
                                <h6 class="card-title text-muted small text-uppercase mb-3">
                                    <i class="fas fa-user me-2"></i>Информация о пользователе
                                </h6>
                                
                                <div class="mb-3">
                                    <label class="form-label small text-muted mb-1">ФИО:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-circle-sm bg-primary-light text-primary me-3">
                                            <i class="fas fa-user fa-sm"></i>
                                        </div>
                                        <div class="fw-medium"><?= Html::encode($model->full_name) ?></div>
                                    </div>
                                </div>
                                
                                <div class="row g-2 mb-3">
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Телефон:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="icon-circle-xs bg-light text-muted me-2">
                                                <i class="fas fa-phone"></i>
                                            </div>
                                            <span class="fw-medium"><?= Html::encode($model->phone) ?></span>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Email:</label>
                                        <div class="d-flex align-items-center">
                                            <div class="icon-circle-xs bg-light text-muted me-2">
                                                <i class="fas fa-envelope"></i>
                                            </div>
                                            <span class="text-truncate"><?= Html::encode($model->email) ?></span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row g-2">
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Уровень игрока:</label>
                                        <div class="badge bg-info-light text-info rounded-pill">
                                            <?= $model->getPlayerLevelLabel() ?>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small text-muted mb-1">Оплата:</label>
                                        <div class="badge bg-success-light text-success rounded-pill">
                                            <?= $model->getPaymentMethodLabel() ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Дополнительная информация -->
                <div class="card border-light shadow-sm mt-4">
                    <div class="card-body">
                        <h6 class="card-title text-muted small text-uppercase mb-3">
                            <i class="fas fa-info-circle me-2"></i>Дополнительная информация
                        </h6>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-light text-muted me-3">
                                        <i class="fas fa-calendar-plus"></i>
                                    </div>
                                    <div>
                                        <label class="form-label small text-muted mb-1">Создана:</label>
                                        <div class="fw-medium"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-light text-muted me-3">
                                        <i class="fas fa-sync-alt"></i>
                                    </div>
                                    <div>
                                        <label class="form-label small text-muted mb-1">Обновлена:</label>
                                        <div class="fw-medium"><?= Yii::$app->formatter->asDatetime($model->updated_at) ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-3">
                            <label class="form-label small text-muted mb-1">Согласие на обработку данных:</label>
                            <div>
                                <?= $model->personal_data_agreement ?
                                    '<span class="badge bg-success-light text-success rounded-pill"><i class="fas fa-check me-1"></i> Да</span>' :
                                    '<span class="badge bg-danger-light text-danger rounded-pill"><i class="fas fa-times me-1"></i> Нет</span>' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer border-0 pt-3 pb-4 px-4">
                <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i> Закрыть
                </button>
                <?= Html::a('<i class="fas fa-edit me-2"></i> Редактировать', 
                    ['update-application', 'id' => $model->id], 
                    ['class' => 'btn btn-primary rounded-pill px-4']
                ) ?>
                <?php if ($model->status === 'new'): ?>
                    <?= Html::a('<i class="fas fa-check me-2"></i> Одобрить', 
                        ['approve-application', 'id' => $model->id], 
                        ['class' => 'btn btn-success rounded-pill px-4', 'data-method' => 'post']
                    ) ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>