<?php
/* @var $model app\models\User */

use yii\helpers\Html;
use yii\helpers\Url;

$applicationsCount = $model->getApplications()->count();
?>
<tr class="border-bottom user-item" data-id="<?= $model->id ?>">
    <td>
        <span class="badge bg-light text-dark">#<?= $model->id ?></span>
    </td>
    <td>
        <div class="d-flex align-items-center">
            <div class="avatar-circle-sm me-3 <?= $model->phone === '89999999999' ? 'bg-danger-light text-danger' : 'bg-primary-light text-primary' ?>">
                <?php if ($model->phone === '89999999999'): ?>
                    <i class="fas fa-crown fa-sm"></i>
                <?php else: ?>
                    <i class="fas fa-user fa-sm"></i>
                <?php endif; ?>
            </div>
            <div>
                <div class="fw-medium"><?= Html::encode($model->full_name) ?></div>
                <?php if ($model->phone === '89999999999'): ?>
                    <span class="badge bg-danger-light text-danger rounded-pill">
                        <i class="fas fa-shield-alt me-1"></i> Администратор
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </td>
    <td>
        <div class="d-flex align-items-center">
            <div class="icon-circle-xs bg-light text-muted me-2">
                <i class="fas fa-phone fa-xs"></i>
            </div>
            <span class="fw-medium"><?= Html::encode($model->phone) ?></span>
        </div>
    </td>
    <td>
        <div class="d-flex align-items-center">
            <div class="icon-circle-xs bg-light text-muted me-2">
                <i class="fas fa-envelope fa-xs"></i>
            </div>
            <span class="text-truncate" style="max-width: 200px;">
                <?= Html::encode($model->email) ?>
            </span>
        </div>
    </td>
    <td>
        <div class="small">
            <div class="fw-medium"><?= Yii::$app->formatter->asDate($model->created_at) ?></div>
            <small class="text-muted">
                <i class="far fa-clock me-1"></i>
                <?= Yii::$app->formatter->asRelativeTime($model->created_at) ?>
            </small>
        </div>
    </td>
    <td>
        <div class="d-flex align-items-center justify-content-between">
            <span class="badge rounded-pill <?= $applicationsCount > 0 ? 'bg-primary-light text-primary' : 'bg-light text-muted' ?>">
                <?= $applicationsCount ?>
            </span>
            <?php if ($applicationsCount > 0): ?>
                <a href="<?= Url::to(['admin/applications', 'user_id' => $model->id]) ?>" 
                   class="btn btn-sm btn-link text-primary p-0" title="Показать заявки">
                    <i class="fas fa-external-link-alt fa-xs"></i>
                </a>
            <?php endif; ?>
        </div>
    </td>
    <td class="text-end">
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-sm btn-outline-info rounded-circle view-user"
                    data-id="<?= $model->id ?>" title="Просмотреть">
                <i class="fas fa-eye fa-sm"></i>
            </button>
            <button type="button" class="btn btn-sm btn-outline-danger rounded-circle delete-user"
                    data-id="<?= $model->id ?>" data-name="<?= Html::encode($model->full_name) ?>"
                    title="Удалить" <?= $model->phone === '89999999999' ? 'disabled' : '' ?>>
                <i class="fas fa-trash fa-sm"></i>
            </button>
        </div>
    </td>
</tr>