<?php
/* @var $model app\models\Application */
use yii\helpers\Html;
use yii\helpers\Url;
?>
<tr class="border-bottom application-item" data-id="<?= $model->id ?>">
    <td>
        <span class="badge bg-light text-dark">#<?= $model->id ?></span>
    </td>
    <td>
        <div class="d-flex align-items-center">
            <div class="avatar-circle-sm bg-light text-muted me-3">
                <i class="fas fa-user fa-sm"></i>
            </div>
            <div>
                <div class="fw-medium"><?= Html::encode($model->full_name) ?></div>
                <small class="text-muted">
                    <i class="fas fa-phone fa-xs me-1"></i>
                    <?= $model->phone ?>
                </small>
            </div>
        </div>
    </td>
    <td>
        <div class="fw-medium"><?= Html::encode($model->game_name) ?></div>
        <small class="text-muted">
            <span class="badge bg-secondary-light text-secondary rounded-pill">
                <?= $model->game_category ?>
            </span>
        </small>
    </td>
    <td>
        <div class="small">
            <div class="fw-medium"><?= Yii::$app->formatter->asDate($model->date) ?></div>
            <small class="text-muted">
                <i class="far fa-clock me-1"></i>
                <?= $model->start_time ?>
            </small>
        </div>
    </td>
    <td>
        <?php 
        $statusColors = [
            'new' => 'warning',
            'approved' => 'success',
            'completed' => 'info'
        ];
        $statusColor = $statusColors[$model->status] ?? 'secondary';
        ?>
        <span class="badge rounded-pill bg-<?= $statusColor ?>-light text-<?= $statusColor ?> d-inline-flex align-items-center">
            <?php if ($model->status === 'new'): ?>
                <i class="fas fa-clock me-1 fa-xs"></i>
            <?php elseif ($model->status === 'approved'): ?>
                <i class="fas fa-check-circle me-1 fa-xs"></i>
            <?php else: ?>
                <i class="fas fa-flag-checkered me-1 fa-xs"></i>
            <?php endif; ?>
            <?= $model->getStatusLabel() ?>
        </span>
    </td>
    <td>
        <div class="small">
            <div class="fw-medium">
                <?= Yii::$app->formatter->asRelativeTime($model->created_at) ?>
            </div>
            <small class="text-muted">
                <?= Yii::$app->formatter->asDate($model->created_at) ?>
            </small>
        </div>
    </td>
    <td class="text-end">
        <div class="btn-group btn-group-sm" role="group">
            <a href="<?= Url::to(['admin/update-application', 'id' => $model->id]) ?>"
               class="btn btn-outline-primary rounded-circle" title="Редактировать">
                <i class="fas fa-edit fa-sm"></i>
            </a>
            <button type="button" class="btn btn-outline-info rounded-circle view-details"
                    data-id="<?= $model->id ?>" title="Подробнее">
                <i class="fas fa-eye fa-sm"></i>
            </button>
            <?php if ($model->status === 'new'): ?>
                <?= Html::a('<i class="fas fa-check fa-sm"></i>', 
                    ['approve-application', 'id' => $model->id], 
                    ['class' => 'btn btn-outline-success rounded-circle', 'title' => 'Одобрить']
                ) ?>
            <?php endif; ?>
        </div>
    </td>
</tr>

<?php
$js = <<<JS
$(document).ready(function() {
    $('.view-details').on('click', function() {
        var id = $(this).data('id');
        
        $.ajax({
            url: '/admin/view-application?id=' + id,
            type: 'GET',
            beforeSend: function() {
                $(this).prop('disabled', true);
            },
            success: function(data) {
                $('body').append(data);
                var modal = new bootstrap.Modal(document.getElementById('applicationModal'));
                modal.show();
                
                $('#applicationModal').on('hidden.bs.modal', function() {
                    $(this).remove();
                });
            },
            complete: function() {
                $(this).prop('disabled', false);
            }
        });
    });
    
    // Эффект при наведении на строку
    $('.application-item').hover(
        function() {
            $(this).css('background-color', '#f8f9fa');
        },
        function() {
            $(this).css('background-color', '');
        }
    );
});
JS;
$this->registerJs($js);
?>