<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property int $game_id
 * @property string $date
 * @property string $start_time
 * @property string $address
 * @property float $price
 * @property int $max_players
 * @property int $current_players
 * @property string $created_at
 *
 * @property Game $game
 */
class Schedule extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%schedule}}';
    }

    public function rules()
    {
        return [
            [['game_id', 'date', 'start_time', 'address', 'price'], 'required'],
            [['game_id', 'max_players', 'current_players'], 'integer'],
            [['price'], 'number'],
            [['date', 'start_time'], 'safe'],
            [['address'], 'string', 'max' => 255],
            ['game_id', 'exist', 'skipOnError' => true, 'targetClass' => Game::class, 'targetAttribute' => ['game_id' => 'id']],
        ];
    }

    public function getGame()
    {
        return $this->hasOne(Game::class, ['id' => 'game_id']);
    }

    public function getApplications()
    {
        return $this->hasMany(Application::class, ['schedule_id' => 'id']);
    }

    public function isFull()
    {
        return $this->current_players >= $this->max_players;
    }

    public function getFormattedDateTime()
    {
        return Yii::$app->formatter->asDate($this->date) . ' ' . $this->start_time;
    }
}