<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property string $category
 * @property string $name
 * @property string $description
 * @property string $image
 * @property int $is_popular
 * @property string $created_at
 */
class Game extends ActiveRecord
{
    const CATEGORY_CLASSIC = 'classic';
    const CATEGORY_CARD = 'card';
    const CATEGORY_ECONOMIC = 'economic';
    const CATEGORY_STRATEGY = 'strategy';
    const CATEGORY_CHILDREN = 'children';

    public static function tableName()
    {
        return '{{%games}}';
    }

    public function rules()
    {
        return [
            [['category', 'name'], 'required'],
            [['category', 'name', 'description', 'image'], 'string'],
            ['category', 'in', 'range' => array_keys(self::getCategories())],
            ['is_popular', 'boolean'],
        ];
    }

    public static function getCategories()
    {
        return [
            self::CATEGORY_CLASSIC => 'Классические',
            self::CATEGORY_CARD => 'Карточные',
            self::CATEGORY_ECONOMIC => 'Экономические',
            self::CATEGORY_STRATEGY => 'Стратегии',
            self::CATEGORY_CHILDREN => 'Для детей',
        ];
    }

    public function getCategoryLabel()
    {
        $categories = self::getCategories();
        return $categories[$this->category] ?? $this->category;
    }

    public function getSchedules()
    {
        return $this->hasMany(Schedule::class, ['game_id' => 'id']);
    }
}