<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%applications}}`.
 */
class m251221_054454_create_applications_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%applications}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'schedule_id' => $this->integer()->notNull(),
            'game_category' => $this->string(50)->notNull(),
            'game_name' => $this->string(100)->notNull(),
            'date' => $this->date()->notNull(),
            'start_time' => $this->time()->notNull(),
            'address' => $this->string(255)->notNull(),
            'price' => $this->decimal(10, 2)->notNull(),
            'full_name' => $this->string(255)->notNull(),
            'email' => $this->string(255)->notNull(),
            'phone' => $this->string(20)->notNull(),
            'payment_method' => $this->string(20)->notNull()->comment('cash, card, transfer'),
            'player_level' => $this->string(20)->notNull()->comment('beginner, amateur, professional'),
            'personal_data_agreement' => $this->boolean()->notNull()->defaultValue(false),
            'status' => $this->string(20)->notNull()->defaultValue('new')->comment('new, approved, completed'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-applications-user_id',
            '{{%applications}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-applications-schedule_id',
            '{{%applications}}',
            'schedule_id',
            '{{%schedule}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-applications-user_id', '{{%applications}}');
        $this->dropForeignKey('fk-applications-schedule_id', '{{%applications}}');
        $this->dropTable('{{%applications}}');
    }
}
