<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%schedule}}`.
 */
class m251221_054343_create_schedule_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%schedule}}', [
            'id' => $this->primaryKey(),
            'game_id' => $this->integer()->notNull(),
            'date' => $this->date()->notNull(),
            'start_time' => $this->time()->notNull(),
            'address' => $this->string(255)->notNull(),
            'price' => $this->decimal(10, 2)->notNull(),
            'max_players' => $this->integer()->defaultValue(10),
            'current_players' => $this->integer()->defaultValue(0),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey(
            'fk-schedule-game_id',
            '{{%schedule}}',
            'game_id',
            '{{%games}}',
            'id',
            'CASCADE'
        );

        // Добавляем тестовые расписания на ближайший месяц
        $startDate = date('Y-m-d');
        for ($i = 1; $i <= 30; $i++) {
            $date = date('Y-m-d', strtotime("+$i days"));
            if (in_array(date('w', strtotime($date)), [0, 5, 6])) { // Воскресенье, пятница, суббота
                $this->insert('{{%schedule}}', [
                    'game_id' => rand(1, 10),
                    'date' => $date,
                    'start_time' => rand(18, 21) . ':00:00',
                    'address' => 'г. Москва, ул. Примерная, д. ' . rand(1, 100),
                    'price' => rand(500, 2000),
                    'max_players' => 10,
                    'current_players' => 0,
                ]);
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-schedule-game_id', '{{%schedule}}');
        $this->dropTable('{{%schedule}}');
    }
}
